#source('~/Desktop/Temperature study/Veterans 1860-1940 import.R', chdir = TRUE)
#source('~/Desktop/Temperature study/Temperature data NHANES import.R', chdir = TRUE)
#source('~/Desktop/Temperature study/Temp Stanford data import.R', chdir = TRUE)

#write.csv(dataVeterans, '~/Desktop/Temperature study/veterans_processed.csv')
#write.csv(dataNHANES, '~/Desktop/Temperature study/NHANES_processed.csv')
#write.csv(ST_data, '~/Desktop/Temperature study/ST_data_processed.csv')


dataVeterans  <- read.csv('~/Desktop/Temperature study/veterans_processed.csv')
dataNHANES    <- read.csv('~/Desktop/Temperature study/NHANES_processed.csv')
ST_data 	  <- read.csv('~/Desktop/Temperature study/STRIDE_processed.csv')


#library(lme4)
#library(merTools)



combinedData<- data.frame(temp=as.numeric(c(dataVeterans$temp, dataNHANES$temp, ST_data$TEMPERATURE)))


combinedData$study_ID <- (c( paste0("vet_",dataVeterans$study_ID), paste0("nhanes_",dataNHANES$study_ID), paste0("stride_",ST_data$study_ID)))
combinedData$study_ID <-as.factor (combinedData$study_ID )
combinedData$age  <- as.numeric(c(dataVeterans$age, dataNHANES$age, ST_data$age_years ))

combinedData$weight_KG  <- as.numeric(c(dataVeterans$weightKG, dataNHANES$weight_KG, ST_data$weight_KG ))

combinedData$height_CM  <- as.numeric(c(dataVeterans$heightCM, dataNHANES$height_CM, ST_data$height_CM ))


combinedData$BMI <- as.numeric (c(dataVeterans$BMI, dataNHANES$BMI, ST_data$BMI ))


combinedData$period <- as.factor(c(rep("1860-1940",length(dataVeterans$temp)),rep("1971-1975",length(dataNHANES$temp)), rep("2007-2017", length(ST_data$TEMPERATURE))))


combinedData$birth_cohort<- as.factor(c(as.character(dataVeterans$birth_cohort), as.character(dataNHANES$birth_cohort), as.character(ST_data$birth_cohort  )))

combinedData$exam_year <- c(dataVeterans$examyear, dataNHANES$exam_year, ST_data$exam_year)


combinedData$exam_month <-c(dataVeterans$exammonth ,dataNHANES$exammonth,  rep(NA, length(ST_data$TEMPERATURE)))
combinedData$sex<- as.factor(c(rep("male",length(dataVeterans$temp)), tolower (as.character(dataNHANES$sex)), tolower (as.character(ST_data$GENDER))))

# Adjusting for temperature measurement difference
temperature_adjustment_C <- 0.05
temperature_adjustment_F <- temperature_adjustment_C * 1.8

combinedData$temp_adjusted <- combinedData$temp - temperature_adjustment_F * (combinedData$period != "2007-2017")

combinedData$temp_C <-(combinedData$temp - 32)/1.8
combinedData$temp_adjC <-combinedData$temp_C - temperature_adjustment_C * (combinedData$period != "2007-2017")

ST_data$temp_C <- (ST_data$TEMPERATURE - 32)/1.8
dataVeterans$temp_C <- (dataVeterans$temp - 32)/1.8
dataNHANES$temp_C <- (dataNHANES$temp - 32)/1.8


combinedData$birth_year <-as.numeric(c(dataVeterans$birth_year, dataNHANES$year_of_birth, ST_data$birth_year))

#combinedData$race <- c(rep("white",length(dataVeterans$temp)), tolower (as.character(dataNHANES$race)), tolower (as.character(ST_data$race )))
combinedData$race <- c(tolower (as.character(dataVeterans $race)), tolower (as.character(dataNHANES$race)), tolower (as.character(ST_data$race )))
combinedData$race[combinedData$race == "unknown"] <- NA
combinedData$race [combinedData$race=="asian"]<- "other"
combinedData$race <- factor(combinedData$race,levels = c("white", "black","other" ))
dataNHANES$race[dataNHANES$race == "unknown"] <- NA
dataNHANES$race <- factor(dataNHANES$race,levels = c("white", "black","other" ))
ST_data$race <- factor(ST_data$race,levels = c("White", "Black","Other"))
ST_data$temp_C <- (ST_data$TEMPERATURE - 32)/1.8

combinedData$time_HR <-as.numeric(c(rep(NA,length(dataVeterans$temp)), dataNHANES$time_HR, ST_data$time_HR))

combinedData$sample_weights <- c(rep(1/length(dataVeterans$temp),length(dataVeterans$temp)),  dataNHANES$sample_weights/sum(dataNHANES$sample_weights),rep(1/length(ST_data$temp_C),length(ST_data$temp_C)))
#combinedData$sample_weights <- c(rep(1,length(dataVeterans$temp)),  dataNHANES$sample_weights/sum(dataNHANES$sample_weights) * length(dataNHANES$temp) ,rep(1, length(ST_data$temp_C)))
write.csv(combinedData,"~/Desktop/Temperature study/combined_data.csv")






